' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

''' <summary>
''' Klasa Product reprezentuje produkt, ktry mg zamwi klient i dostarcza o nim informacji.
''' Klasa Product dziedziczy z ContentBase, ktra dostarcza podstawowych waciwoci jak Id i Title.
''' </summary>
Public Class Product
  Inherits ContentBase

#Region "Zmienne prywatne"

  Private _tagLine As String = String.Empty
  Private _imageUrl As String = String.Empty
  Private _keywords As String = String.Empty

#End Region

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Konstruktor domylny.
  ''' </summary>
  Public Sub New()

  End Sub

  ''' <summary>
  ''' Tworzy nowy product i ustawia prywatn warto Id. Uyteczny przy edycji produktw.
  ''' </summary>
  ''' <param name="id">Identyfikator product w bazie danych.</param>
  Public Sub New(ByVal id As Integer)
    MyBase.New(id)
  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Pobiera a product z bazy danych wywoujc metod Get() in the ProductDB class.
  ''' </summary>
  Public Shared Function [Get](ByVal id As Integer) As Product
    Return ProductDB.Get(id)
  End Function

  ''' <summary>
  ''' Zapisuje a product w bazie danych wywoujc metod Save() in the ProductDB class.
  ''' </summary>
  Public Overrides Sub Save()
    ProductDB.Save(Me)
  End Sub

  ''' <summary>
  ''' Usuwa a product z bazy danych wywoujc metod Delete() in the ProductDB class.
  ''' </summary>
  Public Shared Sub Delete(ByVal id As Integer)
    ProductDB.Delete(id)
  End Sub

  ''' <summary>
  ''' Zwraca list produktw w podanej kategorii z bazy danych.
  ''' </summary>
  ''' <param name="categoryId">identyfikator category w bazie danych.</param>
  ''' <returns></returns>
  Public Shared Function GetProductList(ByVal categoryId As Integer) As DataSet
    Return ProductDB.GetProductList(categoryId)
  End Function

  ''' <summary>
  ''' Zwraca list produktw z bazy danych.
  ''' </summary>
  ''' <returns></returns>
  Public Shared Function GetProductList() As DataSet
    Return ProductDB.GetProductList(-1)
  End Function

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Pobiera lub ustawia waciwo TagLine dla produktu. TagLine jet czym w rodzaju streszczenia lub pierwszego akapitu opisu produktu.
  ''' </summary>
  Public Property TagLine() As String
    Get
      Return _tagLine
    End Get
    Set(ByVal value As String)
      _tagLine = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia ciek wirtualn do Url obrazka przedstawiajcego produkt.
  ''' </summary>
  Public Property ImageUrl() As String
    Get
      Return _imageUrl
    End Get
    Set(ByVal value As String)
      _imageUrl = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia rozdzielon przecinkami list sw kluczowych opisujcych produkt.
  ''' </summary>
  Public Property Keywords() As String
    Get
      Return _keywords
    End Get
    Set(ByVal value As String)
      _keywords = value
    End Set
  End Property

#End Region

End Class
